
Partial Class EditCustomers
    Inherits ApplicationBasePage

#Region " Page Events "

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        '-- If no data exists within the BO, load the top 100 records
        If Customers.Count = 0 Then
            Customers.FillTop100()
        End If

        '-- Set the UI Readonly State
        If Me.IsPostBack Then
            SetUIReadonly()
        End If

        '-- Set the smart navigation
        'Me.SmartNavigation = True

        '-- See if a PK was passed
        If (Me.Request("pk") IsNot Nothing) AndAlso (Not Me.IsPostBack) Then
            Customers.NavigateToPrimaryKey(CType(Me.Request("pk"), Integer))
            Customers.Edit()
            Me.txtFirstName.Focus()
        End If

        '-- Set the state of the buttons
        SetButtonState()
    End Sub

#End Region

#Region " Private Methods "

    ''' <summary>
    ''' Dynamically swaps between allowing the BO to control the readonly state
    ''' and not.  Normally this is not done automatically and can be controlled before 
    ''' run-time by setting the IgnoreUIReadonlyState property on a control or the ManageUIReadonlyState 
    ''' on a business object.  This method was just created to make the developer aware of this feature 
    ''' through the sample applicaiton.
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub SetUIReadonly()
        Customers.ManageUIReadOnlyState = Not Me.chkIgnoreReadonly.Checked

        '-- Set the controls enabled state since it will have already been disabled/enbaled from the
        '   automatic management.  If the management has been turned off, the controls will 
        '   remain in a disabled state.  Again, this does not need to be done in a normal operating
        '   environment and has been done in this application for sample purposes only.  If you do not 
        '   want the BO to manage the states, set the property on the control (IgnoreUIReadonlyState) or 
        '   BO (ManageUIReadonlyState) at design-time.
        Me.txtFirstName.Enabled = Me.chkIgnoreReadonly.Checked
        Me.txtMiddleName.Enabled = Me.chkIgnoreReadonly.Checked
        Me.txtLastName.Enabled = Me.chkIgnoreReadonly.Checked
        Me.txtAddress.Enabled = Me.chkIgnoreReadonly.Checked
        Me.txtCity.Enabled = Me.chkIgnoreReadonly.Checked
        Me.txtState.Enabled = Me.chkIgnoreReadonly.Checked
        Me.txtPostal.Enabled = Me.chkIgnoreReadonly.Checked
    End Sub

    ''' <summary>
    ''' Sets the enabled state of the editing buttons
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub SetButtonState()
        Select Case Customers.EditingState
            Case MicroFour.StrataFrame.Business.BusinessEditingState.Idle
                cmdAdd.Enabled = True
                cmdEdit.Enabled = True
                cmdDelete.Enabled = True
                cmdSave.Enabled = False
                cmdUndo.Enabled = False
                cmdFirst.Visible = True
                cmdPrevious.Visible = True
                cmdNext.Visible = True
                cmdLast.Visible = True
                Me.chkIgnoreReadonly.Enabled = True

            Case Else
                cmdAdd.Enabled = False
                cmdEdit.Enabled = False
                cmdDelete.Enabled = False
                cmdSave.Enabled = True
                cmdUndo.Enabled = True
                cmdFirst.Visible = False
                cmdPrevious.Visible = False
                cmdNext.Visible = False
                cmdLast.Visible = False
                Me.chkIgnoreReadonly.Enabled = False
        End Select
    End Sub

#End Region

#Region " Handled Events "

    Protected Sub cmdFirst_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles cmdFirst.Click
        Customers.Navigate(MicroFour.StrataFrame.Business.BusinessNavigationDirection.First)
    End Sub

    Protected Sub cmdLast_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles cmdLast.Click
        Customers.Navigate(MicroFour.StrataFrame.Business.BusinessNavigationDirection.Last)
    End Sub

    Protected Sub cmdNext_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles cmdNext.Click
        Customers.Navigate(MicroFour.StrataFrame.Business.BusinessNavigationDirection.Next)
    End Sub

    Protected Sub cmdPrevious_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles cmdPrevious.Click
        Customers.Navigate(MicroFour.StrataFrame.Business.BusinessNavigationDirection.Prior)
    End Sub

    Protected Sub cmdAdd_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdAdd.Click
        Customers.Add()
        SetButtonState()
        txtFirstName.Focus()
    End Sub

    Protected Sub cmdEdit_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdEdit.Click
        Customers.Edit()
        SetButtonState()
        txtFirstName.Focus()
    End Sub

    Protected Sub cmdDelete_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdDelete.Click
        If MsgBox("Are you sure you want to delete this record?", MsgBoxStyle.Question Or MsgBoxStyle.YesNo, "Delete Record?") = MsgBoxResult.Yes Then
            Customers.DeleteCurrentRow(False)
            SetButtonState()
        End If
    End Sub

    Protected Sub cmdSave_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdSave.Click
        '-- Establish Locals
        Dim loRule As MicroFour.StrataFrame.Business.BrokenRule
        Dim lcRules As String = ""
        Dim lcAddMsg As String = ""

        If Customers.Save() = MicroFour.StrataFrame.Data.SaveUndoResult.Success Then
            SetButtonState()
        Else
            For Each loRule In Customers.BrokenRules.ToArray()
                If lcRules.Length > 0 Then
                    lcRules &= "<br><br>"
                End If

                lcRules &= "<strong>" & Customers.GetFieldDescription(loRule.FieldName) & "</strong><br>"
                lcRules &= loRule.Description.Replace(Chr(13), "<br>")
            Next

            If lcAddMsg.Length > 0 Then
                If lcRules.Length > 0 Then
                    lcRules &= "<br><br>"
                End If

                lcRules &= lcAddMsg
            End If

            '-- See if there are rules to add
            lblErrors.Text = "<br>" & Me.GenerateWarningTable(lcRules) & "<br>"
            lblErrors.Visible = True
        End If
    End Sub

    Protected Sub cmdUndo_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdUndo.Click
        Customers.Undo(MicroFour.StrataFrame.Business.BusinessUndoType.CurrentRowOnly)
        lblErrors.Visible = False
        SetButtonState()
    End Sub

#End Region

End Class
